/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.palette;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.VWDesignerPreferences;
import filenet.vw.toolkit.design.palette.VWDraggablePaletteItemUI;
import filenet.vw.toolkit.design.palette.resources.VWResource;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.utils.datatransfer.VWTransferable;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import filenet.vw.toolkit.utils.table.VWColorListCellRenderer;
import java.awt.Color;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;

public class VWTextAnnotationPaletteItemUI
extends VWDraggablePaletteItemUI
implements DragGestureListener,
IVWCoordinationEventListener {
    public static final String KEY_TEXT_ANNOTATION = "Text Annotation";
    private VWAuthPropertyData m_authPropertyData = null;

    public VWTextAnnotationPaletteItemUI(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        if (!this.loadIcons()) {
            this.m_normalIcon = VWImageLoader.createImageIcon("text_annotation_yellow_sp.gif");
            this.m_hoverIcon = VWImageLoader.createImageIcon("text_annotation_yellow_sp_h.gif");
        }
        this.setToolTipText(VWResource.s_textAnnotation);
        this.setIcon(this.m_normalIcon);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().addCoordinationEventListener(this);
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        try {
            VWTransferable transferableObj = new VWTransferable(KEY_TEXT_ANNOTATION);
            if (transferableObj != null) {
                dge.startDrag(DragSource.DefaultCopyDrop, transferableObj, this);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        switch (event.getID()) {
            case 740: {
                if (!this.loadIcons() || this.m_normalIcon == null) break;
                this.setIcon(this.m_normalIcon);
            }
        }
    }

    protected void releaseReferences() {
        this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().removeCoordinationEventListener(this);
        this.m_authPropertyData = null;
        super.releaseReferences();
    }

    private boolean loadIcons() {
        try {
            VWMapAttribs mapAttributes;
            Color bgColor;
            VWDesignerPreferences designerPrefs = this.m_authPropertyData.getDesignerCoreData().getDesignerPreferences();
            if (designerPrefs != null && designerPrefs.getMapAttributes() != null && (bgColor = (mapAttributes = designerPrefs.getMapAttributes()).getTextAnnotationDefaultBgColor()) != null) {
                if (bgColor.equals(VWColorListCellRenderer.COLOR_BLUE)) {
                    this.m_normalIcon = VWImageLoader.createImageIcon("text_annotation_blue_sp.gif");
                    this.m_hoverIcon = VWImageLoader.createImageIcon("text_annotation_blue_sp_h.gif");
                    return true;
                }
                if (bgColor.equals(VWColorListCellRenderer.COLOR_GRAY)) {
                    this.m_normalIcon = VWImageLoader.createImageIcon("text_annotation_gray_sp.gif");
                    this.m_hoverIcon = VWImageLoader.createImageIcon("text_annotation_gray_sp_h.gif");
                    return true;
                }
                if (bgColor.equals(VWColorListCellRenderer.COLOR_GREEN)) {
                    this.m_normalIcon = VWImageLoader.createImageIcon("text_annotation_green_sp.gif");
                    this.m_hoverIcon = VWImageLoader.createImageIcon("text_annotation_green_sp_h.gif");
                    return true;
                }
                if (bgColor.equals(VWColorListCellRenderer.COLOR_PINK)) {
                    this.m_normalIcon = VWImageLoader.createImageIcon("text_annotation_pink_sp.gif");
                    this.m_hoverIcon = VWImageLoader.createImageIcon("text_annotation_pink_sp_h.gif");
                    return true;
                }
                if (bgColor.equals(VWColorListCellRenderer.COLOR_YELLOW)) {
                    this.m_normalIcon = VWImageLoader.createImageIcon("text_annotation_yellow_sp.gif");
                    this.m_hoverIcon = VWImageLoader.createImageIcon("text_annotation_yellow_sp_h.gif");
                    return true;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }
}

